<?php 
namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZResumeContentBox extends Widget_Base 
{
	public function get_name() {
		return 'dz-resume-content-box';
	}
	
	public function get_title() {
		return esc_html__('Resume Content Box',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-document-file';
	}
	
	public function get_categories() {
		return [ 'jobzilla' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'resume_content_box_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'Don’t just find. be found put your CV in front of great employers', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'resume_content_box_element_subtitle',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'Explore New Life.', DZ_TH_DOMAIN ),
			]
		);
		
		
		
		$this->add_control(
			'resume_content_box_element_description',
			[
				'label' 		=> esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::TEXTAREA,
				'placeholder'	=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'default'		=> esc_html__( 'The primary purpose of describing your role and responsibilities to potential employers is to provide them with examples of what you achieved on the job and how you contributed overall to the company.', DZ_TH_DOMAIN ),
				'separator'		=>  'default',
				'rows'			=>  5,
				'description'	=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'resume_content_box_element_image',
			[
				'label' 		=> esc_html__( 'Image', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);

		$this->add_control(
				'resume_content_box_element_bg_img',
				[
					'label' 		=> esc_html__( 'Background Image', DZ_TH_DOMAIN ),
					'type' 			=> \Elementor\Controls_Manager::MEDIA,
					'condition' => [
						'resume_content_box_element_style' => ['style_1'],
					],
				]
			);
		
		$this->add_control(
			'resume_content_box_element_link_title',
				[
					'label'  	   => esc_html__('Button Text'),
					'label_block'  => true,
					'type'         => \Elementor\Controls_Manager::TEXT,
					'placeholder'  => esc_html__( 'Enter your Button Text', DZ_TH_DOMAIN ),
					'default'      => esc_html__('Upload Your Resume', DZ_TH_DOMAIN),
				]
		);

		$this->add_control(
			'resume_content_box_element_link',
				[
					'label'  	   => esc_html__('Button Url'),
					'label_block'  => true,
					'type'         => \Elementor\Controls_Manager::URL,
					'placeholder'  => esc_html__( 'Enter your Button Url', DZ_TH_DOMAIN ),
					
				]
		
		);

		$this->add_control(
			'resume_content_box_element_style',
			[
				'label' 	 => esc_html__( 'Style', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => array(
                                'style_1'=>esc_html__('Style 1', DZ_TH_DOMAIN),
                                'style_2'=>esc_html__('Style 2', DZ_TH_DOMAIN),
								'style_3'=>esc_html__('Style 3', DZ_TH_DOMAIN),
                            ),
				'default'	 =>  'style_1',
			]
		);
		
		$this->end_controls_section();
	
	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/resume_content_box_element.php',$settings);
	}
	
	protected function content_template() 
	{

    }
}
?>