<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZSearchForm extends Widget_Base 
{
	public function get_name() {
		return 'dz-search-form';
	}
	
	public function get_title() {
		return esc_html__('Search Form',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-search';
		}
	
	public function get_categories() {
		return [ 'jobzilla' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
				'search_form_element_title',
				[
					'label'		  => esc_html__('Title', DZ_TH_DOMAIN),
					'label_block' => true,
					'type'        => \Elementor\Controls_Manager::TEXT,
					'placeholder' => esc_html__('Enter your title', DZ_TH_DOMAIN),
					'default'     => esc_html__('Search Your Best Cars', DZ_TH_DOMAIN),
				]
		);
		
		$this->add_control(
				'search_form_element_content',
				[
					'label'		  => esc_html__('Content', DZ_TH_DOMAIN),
					'label_block' => true,
					'type'        => \Elementor\Controls_Manager::TEXT,
					'placeholder' => esc_html__('Enter your content', DZ_TH_DOMAIN),
					'default'     => esc_html__('120+ CARS TYPE AND BRANDS', DZ_TH_DOMAIN),
				]
		);

		$this->add_control(
				'search_form_element_job_title',
				[
					'label'		  => esc_html__('Job Title', DZ_TH_DOMAIN),
					'label_block' => true,
					'type'        => \Elementor\Controls_Manager::TEXT,
					'placeholder' => esc_html__('Enter your job title', DZ_TH_DOMAIN),
					'default'     => esc_html__('Job title, keywords...', DZ_TH_DOMAIN),
				]
		);
		
		$this->add_control(
				'search_form_element_job_title_icon',
				[
					'label'		  => esc_html__('Job Title Icon ', DZ_TH_DOMAIN),
					'label_block' => true,
					'type'        => \Elementor\Controls_Manager::ICONS,
					
				]
		);
		
		$this->add_control(
				'search_form_element_city_title',
				[
					'label'		  => esc_html__('City Title', DZ_TH_DOMAIN),
					'label_block' => true,
					'type'        => \Elementor\Controls_Manager::TEXT,
					'placeholder' => esc_html__('Enter your city text', DZ_TH_DOMAIN),
					'default'     => esc_html__('CAR PRICE', DZ_TH_DOMAIN),
				]
		);
		
		$this->add_control(
				'search_form_element_City_icon',
				[
					'label'		  => esc_html__('City Icon ', DZ_TH_DOMAIN),
					'label_block' => true,
					'type'        => \Elementor\Controls_Manager::ICONS,
					
				]
		);
		
		$this->add_control(
				'search_form_element_search_btn_text',
				[
					'label'		  => esc_html__('button Text', DZ_TH_DOMAIN),
					'label_block' => true,
					'type'        => \Elementor\Controls_Manager::TEXT,
					'placeholder' => esc_html__('Enter your btn text', DZ_TH_DOMAIN),
					'default'     => esc_html__('Search car now', DZ_TH_DOMAIN),
				]
		);
		
		$this->add_control(
			'search_form_element_popular_teg_title',
			[
				'label' 		 => esc_html__('Popular Teg Title', DZ_TH_DOMAIN),
				'label_block'	 => true,
				'type' 			 => \Elementor\Controls_Manager::TEXT,
				'default'        => esc_html__('Popular Searches', DZ_TH_DOMAIN),
			]
		);
		
		$this->add_control(
			'search_form_element_popular_teg',
			[
				'label' 		 => esc_html__('Popular Teg Title', DZ_TH_DOMAIN),
				'label_block'	 => true,
				'type' 			 => \Elementor\Controls_Manager::TEXT,
				'default'        => esc_html__(' Designer, Developer, Web, IOS, PHP, Senior, Engineer', DZ_TH_DOMAIN),
			]
		);
		
		
		
		
		
		
		$this->end_controls_section();
	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
      
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/search_form_element.php',$settings);
	}
	
	protected function content_template() 
	{

    }
}