<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZSiteDown extends Widget_Base 
{
	public function get_name() {
		return 'dz-sitedown';
	}
	
	public function get_title() {
		return esc_html__('Sitedown',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-warning';
		}
	
	public function get_categories() {
		return [ 'jobzilla' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Sitedown', DZ_TH_DOMAIN ),
			]
		);
		
		

		$this->end_controls_section();
	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/sitedown_element.php',$settings);
	}
	
	protected function content_template() 
	{

    }
}