<?php
namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZSocialImages extends Widget_Base 
{
	public function get_name() {
		return 'dz-social-images';
	}
	
	public function get_title() {
		return esc_html__('Social Images',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-image-rollover';
	}
	
	public function get_categories() {
		return [ 'jobzilla' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'social_image_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'Testimonials From Our Customers', DZ_TH_DOMAIN ),
			]
		);
		$this->end_controls_section();
		
		
		$this->start_controls_section(
			'item',
			[
				'label' => esc_html__( 'Social Section', DZ_TH_DOMAIN ),
			]
		);
		
		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'social_image_element_item_image',
			[
				'label' 		=> esc_html__( 'Image', DZ_TH_DOMAIN ),
				'type' 			=> Controls_Manager::MEDIA,
			
			]
		);
		$repeater->add_control(
			'social_image_element_item_image_link',
			[
				'label' 		=> esc_html__( 'Image Link', DZ_TH_DOMAIN ),
				'type' 			=> Controls_Manager::URL,
				'label_block' 	=> true,
				
			]
		);
		
		$this->add_control(
			'social_images_element_item',
				[
					'label' 	=> esc_html__( 'Feature', DZ_TH_DOMAIN ),
					'type' 		=> \Elementor\Controls_Manager::REPEATER,
					'fields' 	=> $repeater->get_controls(),
					'default' 	=> [
						[
							'social_image_element_item_image_link' => esc_html__( 'https://www.amazon.in/' , DZ_TH_DOMAIN ),
						],
						[
							'social_image_element_item_image_link' => esc_html__( 'https://www.airbnb.co.in/' , DZ_TH_DOMAIN ),
						],
						[
							'social_image_element_item_image_link' => esc_html__( 'https://www.amazon.in/' , DZ_TH_DOMAIN ),
						],
						[
							'social_image_element_item_image_link' => esc_html__( 'https://paytm.com/' , DZ_TH_DOMAIN ),
						],
						[
							'social_image_element_item_image_link' => esc_html__( 'https://open.spotify.com/' , DZ_TH_DOMAIN ),
						],
						[
							'social_image_element_item_image_link' => esc_html__( 'https://www.amazon.in/' , DZ_TH_DOMAIN ),
						],
						[
							'social_image_element_item_image_link' => esc_html__( 'https://www.figma.com/' , DZ_TH_DOMAIN ),
						],
					],
				
				]
		
		);
		$this->end_controls_section();
	
	
	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		//DZTemplate::show_dz_template('dz-inc/elementor/elements/social_images_element.php',$settings);
	}
	
	protected function content_template() 
	{

    }
}
?>