<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZSubscribe extends Widget_Base 
{
	public function get_name() {
		return 'dz-subscribe';
	}
	
	public function get_title() {
		return esc_html__('Subscribe',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-mail';
		}
	
	public function get_categories() {
		return [ 'jobzilla' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'subscribe_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'Get yourFree
                                            web consultation', DZ_TH_DOMAIN ),
			]
		);
	
		$this->add_control(
			'subscribe_element_subtitle',
			[
				'label' 		=> esc_html__( 'Subtitle', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your Subtitle', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'Latest Blog', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'subscribe_element_icon',
			[
				'label' 		=> esc_html__( 'Icon', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::ICONS,
				
			]
		);
		$this->add_control(
			'subscribe_element_image',
			[
				'label' 		=> esc_html__( 'Image', DZ_TH_DOMAIN ),
				'type' 			=> Controls_Manager::MEDIA,
				
			]
		);
		$this->add_control(
			'subscribe_element_style',
				[
					'label'  	   => esc_html__('Select Style'),
					'label_block'  => true,
					'type'         => \Elementor\Controls_Manager::SELECT,
					'options'	 => array(
                                'style_1'=>esc_html__('Style 1', DZ_TH_DOMAIN),
                                'style_2'=>esc_html__('Style 2', DZ_TH_DOMAIN),
                            ),
					'default'	 =>  'style_1', 
					
				]
		
		);
		$this->add_control(
			'subscribe_element_phone_number',
			[
				'label' 		=> esc_html__( 'Phone Number', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your Phone Number', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( '555-281-5426', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'subscribe_element_email',
			[
				'label' 		=> esc_html__( 'Email', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your Email', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'Info@jobzilla.com', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'group',
			[
				'label' => esc_html__( 'Group', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'subscribe_element_subscribe_subtitle',
			[
				'label' 		=> esc_html__( 'Subscribe Subtitle', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your Subscribe Subtitle', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'Subscribe for free', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'subscribe_element_subscribe_title',
			[
				'label' 		=> esc_html__( 'Subscribe Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your Subscribe text', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'Join our email subscription now to get updates on new jobs and notifications.', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'subscribe_element_subscribe_img',
			[
				'label' 		=> esc_html__( 'Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
				
			]
		);
		
		$this->add_control(
			'subscribe_element_subscribe_btn',
			[
				'label' 		=> esc_html__( 'Button Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your button text', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'Subscribe Now', DZ_TH_DOMAIN ),
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section(
			'item',
			[
				'label' => esc_html__( 'Items', DZ_TH_DOMAIN ),
			]
		);
		
		$repeater = new \Elementor\Repeater();
		
		
		$repeater->add_control(
			'subscribe_element_item_image',
			[
				'label' 		=> esc_html__( 'Image', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
			]
		);
		$repeater->add_control(
		'margin_top',
			[
				'label' => esc_html__( 'TOP', DZ_TH_DOMAIN ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'placeholder' => '0',
				'min' => -100,
				'max' => 100,
				'step' => 1,
			]
		);
		$repeater->add_control(
			'margin_left',
			[
				'label' => esc_html__( 'Left', DZ_TH_DOMAIN ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'placeholder' => '0',
				'min' => -100,
				'max' => 100,
				'step' => 1,
			]
		);
		$repeater->add_control(
			'margin_right',
			[
				'label' => esc_html__( 'Right', DZ_TH_DOMAIN ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'placeholder' => '0',
				'min' => -100,
				'max' => 100,
				'step' => 1,
			]
		);
		$repeater->add_control(
			'margin_bottom',
			[
				'label' => esc_html__( 'Bottom', DZ_TH_DOMAIN ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'placeholder' => '0',
				'min' => -100,
				'max' => 100,
				'step' => 1,
			]
		);
		
		
		$this->add_control(
			'subscribe_element_item',
			[
				'label' 		=> esc_html__( 'Item List', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					
				],
			]
		);
        
        $this->end_controls_section();
		
		
	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/subscribe_element.php',$settings);
	}
	
	protected function content_template() 
	{

    }
}