<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZTestimonialSlider1 extends Widget_Base 
{
	public function get_name() {
		return 'dz-testimonial-slider-1';
	}
	
	public function get_title() {
		return esc_html__('Testimonial Slider 1',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-testimonial';
	}
	
	public function get_categories() {
		return [ 'jobzilla' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'testimonial_slider_1_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'What Our Customers Say About Us', DZ_TH_DOMAIN ),
			]
		);
	
		$this->add_control(
			'testimonial_slider_1_element_subtitle',
			[
				'label' 		=> esc_html__( 'Subtitle', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your Subtitle', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'Clients Testimonials', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'testimonial_slider_1_element_desc',
			[
				'label' 		=> esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::TEXTAREA,
				'placeholder'	=> esc_html__( 'Enter Description', DZ_TH_DOMAIN ),
				'default'		=> esc_html__( 'You need to create an account to find the best and preferred job. lorem
											Ipsum is simply dummy text of the printing and typesetting the standard dummy text ever since the  when an printer took.', DZ_TH_DOMAIN ),
				'separator'		=>  'default',
				'rows'			=>  5,
				'description'	=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'testimonial_slider_1_element_posts_in_categories',
			[
				'label' 		=> esc_html__( 'Include These Categories', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'multiple' 		=> true,
				'type' 		 	=> Controls_Manager::SELECT2,
				'options'		=> dz_get_categories(array( 'taxonomy' => 'testimonial_category'),true),				
				'description'	=> esc_html__( 'Select multiple/ single categories', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'testimonial_slider_1_element_only_featured_posts',
			[
				'label' 		=> esc_html__( 'Include Only Featured Posts', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SWITCHER,
				'return_value' 	=> 'yes',
				'description'	=> esc_html__( 'Choose to show only featured posts.', DZ_TH_DOMAIN ),
			]
		);
		

		$this->add_control(
			'testimonial_slider_1_element_style',
			[
				'label' 	 => esc_html__( 'Style', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => array(
                                'style_1'=>esc_html__('Style 1', DZ_TH_DOMAIN),
                                'style_2'=>esc_html__('Style 2', DZ_TH_DOMAIN),
                                'style_3'=>esc_html__('Style 3', DZ_TH_DOMAIN),
                                'style_4'=>esc_html__('Style 4', DZ_TH_DOMAIN),
                            ),
				'default'	 =>  'style_1',
			]
		);

		$this->add_control(
			'testimonial_slider_1_element_btn',
			[
				'label' 		=> esc_html__( 'Button Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__( 'Enter your button text', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'Show All Quotes', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'testimonial_slider_1_element_link',
			[
				'label' 		=> esc_html__( 'Link', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::URL,
				'placeholder'	=> esc_html__( 'Enter your link', DZ_TH_DOMAIN ),
			]
		);
		$this->end_controls_section();
		
		
	
		
		$this->start_controls_section(
			'advance',
			[
				'label' => esc_html__( 'Advance', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'testimonial_slider_1_element_image_preference',
			[
				'label' 		=> esc_html__( 'Post Image Preference', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SELECT,
				'options'		=> dz_get_image_preference_options_list(),				
				'default'		=>  'image_post_only',
			]
		);
		
		$this->add_control(
			'testimonial_slider_1_element_text_limit',
			[
				'label' 		=> esc_html__( 'Text Limit', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'default'		=> 15,
				'type' 		 	=> Controls_Manager::NUMBER,
				'title'			=>  esc_html__( 'Text Limit', DZ_TH_DOMAIN ),
				'description'	=> esc_html__( 'Enter Text Limit', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'testimonial_slider_1_element_no_of_posts',
			[
				'label' 		=> esc_html__( 'No. Of Posts Per Page', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'default'		=> 4,
				'type' 		 	=> Controls_Manager::NUMBER,
				'title'			=>  esc_html__( 'No. Of Posts Per Page', DZ_TH_DOMAIN ),
				'description'	=> esc_html__( 'Enter no. of posts to show per page.', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'testimonial_slider_1_element_orderby',
			[
				'label' 		   => esc_html__( 'Order By', DZ_TH_DOMAIN ),
				'show_label'	   => true,
				'label_block' 	   => true,
				'type' 		 	   => Controls_Manager::SELECT,
				'options'		   => dz_get_orderby_options_list(),
				'default'		   => 'date' ,
			]
		);
		
		$this->add_control(
			'testimonial_slider_1_element_order',
			[
				'label' 	 => esc_html__( 'Order', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => dz_get_order_options_list(),				
				'default'	 =>  'ASC',
			]
		);		
		$this->end_controls_section();		
	}
	
	protected function render() 
	{
        $settings = $this->get_settings_for_display();	
		$style =  $settings['testimonial_slider_1_element_style'];
		DZTemplate::show_dz_template('dz-inc/elementor/elements/testimonial_slider_1_element.php',$settings);

		echo "<script>
				jQuery(document).ready(function(){
					if(jQuery('.elementor-element-edit-mode').length > 0){
			";
			
			if($style == 'style_1'){
			echo 'handleTwmTestimonial1Carousel();';
			}else if($style == 'style_2'){				
				echo 'handleTwmTestimonial2Carousel();';
			}elseif($style == 'style_3'){
				echo 'handleTwmTestimonial3Carousel();';
			}elseif($style == 'style_4'){
				echo 'handleTwmTestimonial8Carousel();';
			}
				echo "}					
				});
			 </script>
			";
	}
	
	protected function content_template() 
	{

    }
}