<?php
/**
 * Kingcomposer array
 *
 * @package Student WP
 * @author DexignZone
 * @version 1.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	die( 'Restricted' );
}


$orderby_options = array(
					'date'			=>	esc_html__('Date', DZ_TH_DOMAIN),
					'title'			=>	esc_html__('Title', DZ_TH_DOMAIN),
					'name'			=>	esc_html__('Name', DZ_TH_DOMAIN),
					'author'		=>	esc_html__('Author', DZ_TH_DOMAIN),
					'comment_count' =>	esc_html__('Comment Count', DZ_TH_DOMAIN),
					'views_count' 	=>	esc_html__('View Count', DZ_TH_DOMAIN),
					'rand' 		  	=>	esc_html__('Random', DZ_TH_DOMAIN) 
					);
					
$cat_orderby_options = array(
						'date'=>esc_html__('Date', DZ_TH_DOMAIN),
						'title'=>esc_html__('Title', DZ_TH_DOMAIN),
						'name'=>esc_html__('Name', DZ_TH_DOMAIN),
						'random' =>esc_html__('Random', DZ_TH_DOMAIN) 
					);

/*'normal' => 'Normal', we will not give normal page loading paginaton in elements  */ 
$pagination_options = array(
					'no' => 'No Pagination',
					'load_more' => 'Ajax Load More Button',
					/*'infinate_scroll' => 'Infinite Scroll', */
					);

$order_options = array('ASC'=>esc_html__('Ascending', DZ_TH_DOMAIN),'DESC'=>esc_html__('Descending', DZ_TH_DOMAIN) );

$sidebar_layout_options = array('left'=>esc_html__('Left Sidebar', DZ_TH_DOMAIN),'right'=>esc_html__('Right Sidebar', DZ_TH_DOMAIN) );

$post_view_option = array(
						'trending'=>esc_html__('Trending Posts', DZ_TH_DOMAIN),
						'popular'=>esc_html__('Popular Posts', DZ_TH_DOMAIN),
						'featured'=>esc_html__('Feature Post', DZ_TH_DOMAIN),
					);

$selected_sidebar_options = dz_get_sidebars();

$image_preference_options = array('all_posts'=>'All Posts', 'image_post_only'=>'Image Post Only', 'text_post_only' => 'Text Post Only'); 

$post_by_label_options = array('all_posts'=>'All Posts', 'sticky_only' => 'Sticky Only', 'featured_only' => 'Featured Only');

$posts_in_categories_options = dz_get_categories(array( 'taxonomy' => 'category'),true);


$contact_form_options = get_posts(array('post_type'     => 'wpcf7_contact_form','numberposts'   => -1));
$contact_form_options = wp_list_pluck($contact_form_options, 'post_title', 'ID');

/* $all_posts = get_posts($post_args);		
$all_post_options = wp_list_pluck($all_posts, 'post_title', 'ID'); */


$about_us_content = '<p class="first-content">Lorem ipsum dolor sit amet, conse ctetur adipiscing elit. Sed maximus orci ac condi mentum efficitur. Suspendi potenti. Fusce diam felis, ullamcor aca felis sed, volutpat varius tortor. Ut eleifend justo sed quam blandit, vehicula ante hendrerit. Sed condimentum libero vel eros porta, eu malesuada nulla bibendum. Proin varius sollicitudin nulla quis fermentum. Nunc vitae arcu eget diam gravida ultrices finibus nec mi. Maecenas egestas libero.</p>

<ul class="blog-text-list">
 	<li><a class="text-secondry">Duis auctor sed elit quis consequat.</a> Fusce est quam, sodales vel eros vitae, dictum consectetur dolor. Fusce convallis mauris tellus, eu aliquet magna aliquet eget.</li>
 	<li>Nam iaculis, <a class="text-secondry">enim ut elementum maximus, quam lectus convallis metus, </a>id suscipit risus lectus id urna. Cras viverra consectetur diam. Morbi sed consequat tellus, in vehicula urna.</li>
 	<li><a class="text-secondry">Morbi sit amet diam sodales, sodales purus quis, </a>feugiat turpis. Maecenas elementum mauris quis plac erat maximus. <a class="text-secondry">Curabitur elementum lobortis malesuada.</a></li>
</ul>
<p>Aliquam laoreet fringilla velit, quis pulvinar ex bibendum vestibulum. Aenean vel dapibus ex. Curabitur sodales dui ut hendrerit volutpat. Phasellus fringilla semper urna, eu dapibus lacus porttitor at. Sed eget pellentes orci. Aliquam pulvinar augue sed molestie semper. Integer ullamcorper magna fringilla arcu rutrum, sed porttitor ex viverra.</p>
<p>Donec ultricies convallis urna. Morbi consequat vestibulum nunc sed semper. Proin iaculis risus eleifend, efficitur eros et, tristique tortor. Integer nec lacinia augue. Curabitur mattis vel orci id mattis.</p>';


$options = array();
															
/*=================================================================================*/			

/* banner_image */
$options['dz_banner_image_element']	=	array(
						'name' => esc_html__('Banner Image', DZ_TH_DOMAIN),
						'base' => 'dz_banner_image_element',
						'class' => '',
						'category' => esc_html__('Jobzilla', DZ_TH_DOMAIN),
						'icon' => 'dz-banner-image-kc' ,
						'description' => esc_html__('Shows Banner Image.', DZ_TH_DOMAIN),	
						'params' => array(
							array(
								'type' => 'attach_image_url',
								'label' => esc_html__( 'Banner Image', DZ_TH_DOMAIN ),
								'name' => 'banner_image_element_image',
								'description' => esc_html__( 'choose banner image.', DZ_TH_DOMAIN ),
							),
						)
					);

/* Radio Image */
/* $options['dz_radio_image_element']	=	array(
					'name' => esc_html__('Radio Image', DZ_TH_DOMAIN),
					'base' => 'dz_radio_image_element',
					'class' => '',
					'category' => esc_html__('Jobzilla', DZ_TH_DOMAIN),
					'icon' => 'dz-radio-image-kc',
					'description' => esc_html__('Show Radio Image.', DZ_TH_DOMAIN),
					'params' => array(
						array(
							'type' => 'radio_image',
							'label' => esc_html__('Choose Template', DZ_TH_DOMAIN ),
							'name' => 'radio_image_field',
							'options' => array(
								'value_1'	=> get_template_directory_uri().'/dz-inc/assets/images/post-layout/audio-post.png',
								'value_2'	=> get_template_directory_uri().'/dz-inc/assets/images/post-layout/gutenberg.png',
							),
							'description' => esc_html__('Choose Slider', DZ_TH_DOMAIN )
						),
					),
			); */

/* Revolution Slider */
$options['dz_revolution_slider_element']	=	array(
					'name' => esc_html__('Revolution Slider', DZ_TH_DOMAIN),
					'base' => 'dz_revolution_slider_element',
					'class' => '',
					'category' => esc_html__('Jobzilla', DZ_TH_DOMAIN),
					'icon' => 'dz-revolution-slider-kc',
					'description' => esc_html__('Show Revolution Slider.', DZ_TH_DOMAIN),
					'params' => array(
						array(
							'type' => 'dropdown',
							'label' => esc_html__('Choose Slider', DZ_TH_DOMAIN ),
							'name' => 'slider_slug',
							'options' => dz_get_rev_slider(),
							'description' => esc_html__('Choose Slider', DZ_TH_DOMAIN )
						),
					),
			);
		
/* post_slider_1 */
$options['dz_post_slider_1_element']	=	array(
					'name' => esc_html__('Post Slider 1', DZ_TH_DOMAIN),
					'base' => 'dz_post_slider_1_element',
					'class' => '',
					'category' => esc_html__('Jobzilla', DZ_TH_DOMAIN),
					'icon' => 'dz-post-slider-1-kc' ,
					'description' => esc_html__('Shows post owl slider style 1.', DZ_TH_DOMAIN),	
					'params' => array(
						esc_html__( 'General', DZ_TH_DOMAIN ) => array(
							array(
								"type"			=>	"text",
								"label"			=>	esc_html__('Section Heading', DZ_TH_DOMAIN ),
								"name"			=>	"post_slider_1_element_title",
								"value"			=> 	esc_html__('', DZ_TH_DOMAIN ),
							),
							array(
								"type"			=>	"text",
								"label"			=>	esc_html__('Section Description', DZ_TH_DOMAIN ),
								"name"			=>	"post_slider_1_element_description",
								"value"			=> 	esc_html__('', DZ_TH_DOMAIN ),
							),
							array(
								'type' 			=> 'multiple', 
								'label' 		=> esc_html('Include These Categories', DZ_TH_DOMAIN ),
								'name' 			=> 'post_slider_1_element_posts_in_categories',
								"options" 		=>  $posts_in_categories_options,
								'description' 	=> esc_html('Select multiple/ single categories', DZ_TH_DOMAIN ),
								'value'			=>array('trending-post')
							),	
							array(
								'type' => 'attach_image_url',
								'label' => esc_html__( 'Background Image', DZ_TH_DOMAIN ),
								'name' => 'post_slider_1_element_bg_image',
								'description' => esc_html__( 'choose background image.', DZ_TH_DOMAIN ),
							),
							array(
								 'type' 		=> 'toggle',
								 'label' 		=> esc_html__( 'Include Only Featured Posts', DZ_TH_DOMAIN ),
								 'name' 		=> 'post_slider_1_element_only_featured_posts',
								 'description' 	=> esc_html__( 'Choose to show only featured posts.', DZ_TH_DOMAIN ),
								 'value' 		=> 'no'
							),
							
						),
						esc_html__( 'Advance', DZ_TH_DOMAIN ) => array(
							array(
								"type"			=>	"text",
								"label"			=>	esc_html__('Text Limit', DZ_TH_DOMAIN ),
								"name"			=>	"post_slider_1_element_text_limit",
								"description"	=>	esc_html__('Enter text limit of post title to Show. 0 for full title.', DZ_TH_DOMAIN ),
								'value'			=> 	'7'
							),
							array(
								"type"			=>	"text",
								"label"			=>	esc_html__('No. Of Posts Per Page', DZ_TH_DOMAIN ),
								"name"			=>	"post_slider_1_element_no_of_posts",
								"description"	=>	esc_html__('Enter no. of posts to show per page.', DZ_TH_DOMAIN ),
								"value"			=> '10'
							),
							array(
								 'type' 		=> 'select',
								 'label' 		=> esc_html__( 'Post Image Preference', DZ_TH_DOMAIN ),
								 'name' 		=> 'post_slider_1_element_image_preference',
								 'options'		=> $image_preference_options,
								 'value' 		=> 'image_post_only',
							),
							array(
								"type"			=>	"select",
								"label"			=>	esc_html__("Order By", DZ_TH_DOMAIN),
								"name"			=>	"post_slider_1_element_orderby",
								'options'		=>	$orderby_options,
								"description"	=>	esc_html__("Enter the sorting order.", DZ_TH_DOMAIN),
								'value'			=> 	'date'
							),
							array(
								"type"			=>	"select",
								"label"			=>	esc_html__("Order", DZ_TH_DOMAIN),
								"name"			=>	"post_slider_1_element_order",
								'options'		=>	$order_options,			
								"description"	=>	esc_html__("Enter the sorting order.", DZ_TH_DOMAIN),
								'value'			=>	'DESC'
							),
						),
					),
			);


/* post_slider_2 */
$options['dz_post_slider_2_element']	=	array(
					'name' => esc_html__('Post Slider 2', DZ_TH_DOMAIN),
					'base' => 'dz_post_slider_2_element',
					'class' => '',
					'category' => esc_html__('Jobzilla', DZ_TH_DOMAIN),
					'icon' => 'dz-post-slider-2-kc' ,
					'description' => esc_html__('Shows Post Slider style 2.', DZ_TH_DOMAIN),
					'params' => array(
						esc_html__( 'General', DZ_TH_DOMAIN ) => array(	
							array(
								"type"			=>	"text",
								"label"			=>	esc_html__('Title', DZ_TH_DOMAIN ),
								"name"			=>	"post_slider_2_element_title",
								"description"	=>	esc_html__('Enter section title.', DZ_TH_DOMAIN ),
							),
							array(
								"type"			=>	"textarea",
								"label"			=>	esc_html__('Description', DZ_TH_DOMAIN ),
								"name"			=>	"post_slider_2_element_description",
								"description"	=>	esc_html__('Enter section description.', DZ_TH_DOMAIN ),
							),
							array(
								'type' => 'multiple', 
								'label' => __('Include These Categories', DZ_TH_DOMAIN ),
								'name' => 'post_slider_2_element_posts_in_categories',
								"options" =>  $posts_in_categories_options,
								'description' => __('Select multiple/ single categories', DZ_TH_DOMAIN ),
								'value'		=> 	'0'
							),	
							array(
								 'type' => 'toggle',
								 'label' => esc_html__( 'Include Only Featured Posts', DZ_TH_DOMAIN ),
								 'name' => 'post_slider_2_element_only_featured_posts',
								 'description' => esc_html__( 'Choose to show only featured posts.', DZ_TH_DOMAIN ),
								 'value' => 'no'
							),
						),
						esc_html__( 'Advance', DZ_TH_DOMAIN ) => array(
							array(
								"type"			=>	"text",
								"label"			=>	esc_html__('Text Limit', DZ_TH_DOMAIN ),
								"name"			=>	"post_slider_2_element_text_limit",
								"description"	=>	esc_html__('Enter text limit of post title to Show. 0 for full title.', DZ_TH_DOMAIN ),
								'value'			=> 	'7'
							),
							array(
								"type"			=>	"text",
								"label"			=>	esc_html__('No. Of Posts Per Page', DZ_TH_DOMAIN ),
								"name"			=>	"post_slider_2_element_no_of_posts",
								"description"	=>	esc_html__('Enter no. of posts to show per page.', DZ_TH_DOMAIN ),
								'value'			=> 	'2'
							),
							array(
								 'type' 		=> 'select',
								 'label' 		=> esc_html__( 'Post Image Preference', DZ_TH_DOMAIN ),
								 'name' 		=> 'post_slider_2_element_image_preference',
								 'options'		=> $image_preference_options,
								 'value' 		=> 'image_post_only',
							),
							array(
								"type"			=>	"select",
								"label"			=>	esc_html__("Order By", DZ_TH_DOMAIN),
								"name"			=>	"post_slider_2_element_orderby",
								'options'		=>	$orderby_options,
								"description"	=>	esc_html__("Enter the sorting order.", DZ_TH_DOMAIN),
								'value'			=> 	'date'
							),
							array(
								"type"			=>	"select",
								"label"			=>	esc_html__("Order", DZ_TH_DOMAIN),
								"name"			=>	"post_slider_2_element_order",
								'options'		=>	$order_options,			
								"description"	=>	esc_html__("Enter the sorting order.", DZ_TH_DOMAIN),
								'value'			=> 	'DESC'
							)
						),
					),
			);			
			
/* post_collage_1 */
$options['dz_post_collage_1_element']	=	array(
					'name' => esc_html__('Post Collage 1', DZ_TH_DOMAIN),
					'base' => 'dz_post_collage_1_element',
					'class' => '',
					'category' => esc_html__('Jobzilla', DZ_TH_DOMAIN),
					'icon' => 'dz-post-collage-1-kc' ,
					'description' => esc_html__('Shows Post Collage style 1.', DZ_TH_DOMAIN),
					'params' => array(
						esc_html__( 'General', DZ_TH_DOMAIN ) => array(
							array(
								"type"			=>	"text",
								"label"			=>	esc_html__('Title', DZ_TH_DOMAIN ),
								"name"			=>	"post_collage_1_element_title",
								"description"	=>	esc_html__('Enter section title.', DZ_TH_DOMAIN ),
								'value'			=> esc_html__('', DZ_TH_DOMAIN )
							),
							array(
								"type"			=>	"text",
								"label"			=>	esc_html__('Description', DZ_TH_DOMAIN ),
								"name"			=>	"post_collage_1_element_description",
								"description"	=>	esc_html__('Enter section description.', DZ_TH_DOMAIN ),
								'value'			=> esc_html__('', DZ_TH_DOMAIN )
							),
							array(
								"type"			=>	"text",
								"label"			=>	esc_html__('Text Limit', DZ_TH_DOMAIN ),
								"name"			=>	"post_collage_1_element_text_limit",
								"description"	=>	esc_html__('Enter text limit of posts to Show.', DZ_TH_DOMAIN ),
								'value'			=> 	'7'
							),
							array(
								'type' => 'multiple', 
								'label' => __('Include These Categories', DZ_TH_DOMAIN ),
								'name' => 'post_collage_1_element_posts_in_categories',
								"options" =>  $posts_in_categories_options,
								'description' => __('Select multiple/ single categories', DZ_TH_DOMAIN ),
								'value'			=> array('beauty','fashion','lifestyle')
							),	
							array(
								 'type' 		=> 'select',
								 'label' 		=> esc_html__( 'Post Image Preference', DZ_TH_DOMAIN ),
								 'name' 		=> 'post_collage_1_element_image_preference',
								 'options'		=> $image_preference_options,
								 'value' 		=> 'image_post_only',
							),
							array(
								 'type' => 'toggle',
								 'label' => esc_html__( 'Include Only Featured Posts', DZ_TH_DOMAIN ),
								 'name' => 'post_collage_1_element_only_featured_posts',
								 'description' => esc_html__( 'Choose to show only featured posts.', DZ_TH_DOMAIN ),
								 'value' => 'no'
							),
						),
						esc_html__( 'Advance', DZ_TH_DOMAIN ) => array(
							array(
								"type"			=>	"select",
								"label"			=>	esc_html__("Order By", DZ_TH_DOMAIN),
								"name"			=>	"post_collage_1_element_orderby",
								'options'		=>	$orderby_options,
								"description"	=>	esc_html__("Enter the sorting order.", DZ_TH_DOMAIN),
								'value'			=> 	'date',
							),
							array(
								"type"			=>	"select",
								"label"			=>	esc_html__("Order", DZ_TH_DOMAIN),
								"name"			=>	"post_collage_1_element_order",
								'options'		=>	$order_options,			
								"description"	=>	esc_html__("Enter the sorting order.", DZ_TH_DOMAIN),
								'value'			=> 	'DESC',
							),
						),
					),
			);

/* post_listing_1 */
$options['dz_post_listing_1_element']	=	array(
					'name' => esc_html__('Post Listing 1', DZ_TH_DOMAIN),
					'base' => 'dz_post_listing_1_element',
					'class' => '',
					'category' => esc_html__('Jobzilla', DZ_TH_DOMAIN),
					'icon' => 'dz-post-listing-1-kc' ,
					'description' => esc_html__('Shows Post Listing style 1.', DZ_TH_DOMAIN),
					'params' => array(
						esc_html__( 'General', DZ_TH_DOMAIN ) => array(	
							array(
								"type"			=>	"text",
								"label"			=>	esc_html__('Title', DZ_TH_DOMAIN ),
								"name"			=>	"post_listing_1_element_title",
								"description"	=>	esc_html__('Enter section title.', DZ_TH_DOMAIN ),
							),
							array(
								"type"			=>	"textarea",
								"label"			=>	esc_html__('Description', DZ_TH_DOMAIN ),
								"name"			=>	"post_listing_1_element_description",
								"description"	=>	esc_html__('Enter section description.', DZ_TH_DOMAIN ),
							),
							array(
								"type"			=>	"text",
								"label"			=>	esc_html__('Text Limit', DZ_TH_DOMAIN ),
								"name"			=>	"post_listing_1_element_text_limit",
								"description"	=>	esc_html__('Enter text limit of post title to Show. 0 for full title', DZ_TH_DOMAIN ),
								'value'			=> 	'7'
							),
							array(
								'type' => 'multiple', 
								'label' => __('Include These Categories', DZ_TH_DOMAIN ),
								'name' => 'post_listing_1_element_posts_in_categories',
								"options" =>  $posts_in_categories_options,
								'description' => __('Select multiple/ single categories', DZ_TH_DOMAIN ),
								'value'		=> 	'0'
							),	
							array(
							 'type' => 'toggle',
							 'label' => esc_html__( 'Include Only Featured Posts', DZ_TH_DOMAIN ),
							 'name' => 'post_listing_1_element_only_featured_posts',
							 'description' => esc_html__( 'Choose to show only featured posts.', DZ_TH_DOMAIN ),
							 'value' => 'no'
							),
						),
						esc_html__( 'Pagination', DZ_TH_DOMAIN ) => array(
							array(
								 'type' => 'select',
								 'label' => esc_html__( 'Pagination Style', DZ_TH_DOMAIN ),
								 'name' => 'post_listing_1_element_pagination_style',
								 'options' => $pagination_options,
								 'description' => esc_html__( 'You can choose pagination style from here.', DZ_TH_DOMAIN ),
								 'value' => 'yes'
							),
							array(
								 'type' 		=> 'select',
								 'label' 		=> esc_html__( 'Post Image Preference', DZ_TH_DOMAIN ),
								 'name' 		=> 'post_listing_1_element_image_preference',
								 'options'		=> $image_preference_options,
								 'value' 		=> 'image_post_only',
							),
							array(
								"type"			=>	"text",
								"label"			=>	esc_html__('No. Of Posts Per Page', DZ_TH_DOMAIN ),
								"name"			=>	"post_listing_1_element_no_of_posts",
								"description"	=>	esc_html__('Enter no. of posts to show per page.', DZ_TH_DOMAIN ),
								'value'			=> 	'3'
							),
							array(
								"type"			=>	"select",
								"label"			=>	esc_html__("Order By", DZ_TH_DOMAIN),
								"name"			=>	"post_listing_1_element_orderby",
								'options'		=>	$orderby_options,
								"description"	=>	esc_html__("Enter the sorting order.", DZ_TH_DOMAIN),
								'value'			=> 	'date'
							),
							array(
								"type"			=>	"select",
								"label"			=>	esc_html__("Order", DZ_TH_DOMAIN),
								"name"			=>	"post_listing_1_element_order",
								'options'		=>	$order_options,			
								"description"	=>	esc_html__("Enter the sorting order.", DZ_TH_DOMAIN),
								'value'			=> 	'DESC'
							)
						),
						//Tabs Start
						esc_html__( 'Sidebar', DZ_TH_DOMAIN ) => array(
							array(
							   'type' => 'dropdown',
							   'label' => esc_html__( 'Choose Sidebar', DZ_TH_DOMAIN ),
							   'name' => 'post_listing_1_element_selected_sidebar',
							   'options' => $selected_sidebar_options,
							   'description' => esc_html__( 'Choose Sidebar.', DZ_TH_DOMAIN ),
							   'value'			=> 	'dz_blog_sidebar'
							),
							array(
								"type"			=>	"select",
								"label"			=>	esc_html__("Sidebar Selection", DZ_TH_DOMAIN),
								"name"			=>	"post_listing_1_element_sidebar_layout",
								'options'		=>	$sidebar_layout_options,			
								"description"	=>	esc_html__("Select Sidebar or show with out sidebar.", DZ_TH_DOMAIN),
								'value'			=> 	'right'
							),
						),
						//Tabs End
					),
			);

/* post_listing_2 */
$options['dz_post_listing_2_element']	=	array(
					'name' => esc_html__('Post Listing 2', DZ_TH_DOMAIN),
					'base' => 'dz_post_listing_2_element',
					'class' => '',
					'category' => esc_html__('Jobzilla', DZ_TH_DOMAIN),
					'icon' => 'dz-post-listing-2-kc' ,
					'description' => esc_html__('Shows Post Listing style 2.', DZ_TH_DOMAIN),
					'params' => array(
						esc_html__( 'General', DZ_TH_DOMAIN ) => array(	
							array(
								"type"			=>	"text",
								"label"			=>	esc_html__('Title', DZ_TH_DOMAIN ),
								"name"			=>	"post_listing_2_element_title",
								"description"	=>	esc_html__('Enter section title.', DZ_TH_DOMAIN ),
							),
							array(
								"type"			=>	"textarea",
								"label"			=>	esc_html__('Description', DZ_TH_DOMAIN ),
								"name"			=>	"post_listing_2_element_description",
								"description"	=>	esc_html__('Enter section description.', DZ_TH_DOMAIN ),
							),
							array(
								"type"			=>	"text",
								"label"			=>	esc_html__('Text Limit', DZ_TH_DOMAIN ),
								"name"			=>	"post_listing_2_element_text_limit",
								"description"	=>	esc_html__('Enter text limit of post title to Show. 0 for full title', DZ_TH_DOMAIN ),
								'value'			=> 	'7'
							),
							array(
								'type' => 'multiple', 
								'label' => __('Include These Categories', DZ_TH_DOMAIN ),
								'name' => 'post_listing_2_element_posts_in_categories',
								"options" =>  $posts_in_categories_options,
								'description' => __('Select multiple/ single categories', DZ_TH_DOMAIN ),
								'value'		=> 	'0'
							),	
							array(
							 'type' => 'toggle',
							 'label' => esc_html__( 'Include Only Featured Posts', DZ_TH_DOMAIN ),
							 'name' => 'post_listing_2_element_only_featured_posts',
							 'description' => esc_html__( 'Choose to show only featured posts.', DZ_TH_DOMAIN ),
							 'value' => 'no'
							),
						),
						esc_html__( 'Pagination', DZ_TH_DOMAIN ) => array(
							array(
								 'type' => 'select',
								 'label' => esc_html__( 'Pagination Style', DZ_TH_DOMAIN ),
								 'name' => 'post_listing_2_element_pagination_style',
								 'options' => $pagination_options,
								 'description' => esc_html__( 'You can choose pagination style from here.', DZ_TH_DOMAIN ),
								 'value' => 'yes'
							),
							array(
								 'type' 		=> 'select',
								 'label' 		=> esc_html__( 'Post Image Preference', DZ_TH_DOMAIN ),
								 'name' 		=> 'post_listing_2_element_image_preference',
								 'options'		=> $image_preference_options,
								 'value' 		=> 'image_post_only',
							),
							array(
								"type"			=>	"text",
								"label"			=>	esc_html__('No. Of Posts Per Page', DZ_TH_DOMAIN ),
								"name"			=>	"post_listing_2_element_no_of_posts",
								"description"	=>	esc_html__('Enter no. of posts to show per page.', DZ_TH_DOMAIN ),
								'value'			=> 	'3'
							),
							array(
								"type"			=>	"select",
								"label"			=>	esc_html__("Order By", DZ_TH_DOMAIN),
								"name"			=>	"post_listing_2_element_orderby",
								'options'		=>	$orderby_options,
								"description"	=>	esc_html__("Enter the sorting order.", DZ_TH_DOMAIN),
								'value'			=> 	'date'
							),
							array(
								"type"			=>	"select",
								"label"			=>	esc_html__("Order", DZ_TH_DOMAIN),
								"name"			=>	"post_listing_2_element_order",
								'options'		=>	$order_options,			
								"description"	=>	esc_html__("Enter the sorting order.", DZ_TH_DOMAIN),
								'value'			=> 	'DESC'
							)
						),
						//Tabs Start
						esc_html__( 'Sidebar', DZ_TH_DOMAIN ) => array(
							array(
							   'type' => 'dropdown',
							   'label' => esc_html__( 'Choose Sidebar', DZ_TH_DOMAIN ),
							   'name' => 'post_listing_2_element_selected_sidebar',
							   'options' => $selected_sidebar_options,
							   'description' => esc_html__( 'Choose Sidebar.', DZ_TH_DOMAIN ),
							   'value'			=> 	'dz_blog_sidebar'
							),
							array(
								"type"			=>	"select",
								"label"			=>	esc_html__("Sidebar Selection", DZ_TH_DOMAIN),
								"name"			=>	"post_listing_2_element_sidebar_layout",
								'options'		=>	$sidebar_layout_options,			
								"description"	=>	esc_html__("Select Sidebar or show with out sidebar.", DZ_TH_DOMAIN),
								'value'			=> 	'right'
							),
						),
						//Tabs End
					),
			);

/* post_listing_3 */
$options['dz_post_listing_3_element']	=	array(
					'name' => esc_html__('Post Listing 3', DZ_TH_DOMAIN),
					'base' => 'dz_post_listing_3_element',
					'class' => '',
					'category' => esc_html__('Jobzilla', DZ_TH_DOMAIN),
					'icon' => 'dz-post-listing-3-kc' ,
					'description' => esc_html__('Shows Post Listing style 3.', DZ_TH_DOMAIN),
					'params' => array(
						esc_html__( 'General', DZ_TH_DOMAIN ) => array(	
							array(
								"type"			=>	"text",
								"label"			=>	esc_html__('Title', DZ_TH_DOMAIN ),
								"name"			=>	"post_listing_3_element_title",
								"description"	=>	esc_html__('Enter section title.', DZ_TH_DOMAIN ),
							),
							array(
								"type"			=>	"textarea",
								"label"			=>	esc_html__('Description', DZ_TH_DOMAIN ),
								"name"			=>	"post_listing_3_element_description",
								"description"	=>	esc_html__('Enter section description.', DZ_TH_DOMAIN ),
							),
							array(
								"type"			=>	"text",
								"label"			=>	esc_html__('Text Limit', DZ_TH_DOMAIN ),
								"name"			=>	"post_listing_3_element_text_limit",
								"description"	=>	esc_html__('Enter text limit of post title to Show. 0 for full title', DZ_TH_DOMAIN ),
								'value'			=> 	'7'
							),
							array(
								'type' => 'multiple', 
								'label' => __('Include These Categories', DZ_TH_DOMAIN ),
								'name' => 'post_listing_3_element_posts_in_categories',
								"options" =>  $posts_in_categories_options,
								'description' => __('Select multiple/ single categories', DZ_TH_DOMAIN ),
								'value'		=> 	'0'
							),	
							array(
							 'type' => 'toggle',
							 'label' => esc_html__( 'Include Only Featured Posts', DZ_TH_DOMAIN ),
							 'name' => 'post_listing_3_element_only_featured_posts',
							 'description' => esc_html__( 'Choose to show only featured posts.', DZ_TH_DOMAIN ),
							 'value' => 'no'
							),
						),
						esc_html__( 'Pagination', DZ_TH_DOMAIN ) => array(
							array(
								 'type' => 'select',
								 'label' => esc_html__( 'Pagination Style', DZ_TH_DOMAIN ),
								 'name' => 'post_listing_3_element_pagination_style',
								 'options' => $pagination_options,
								 'description' => esc_html__( 'You can choose pagination style from here.', DZ_TH_DOMAIN ),
								 'value' => 'yes'
							),
							array(
								 'type' 		=> 'select',
								 'label' 		=> esc_html__( 'Post Image Preference', DZ_TH_DOMAIN ),
								 'name' 		=> 'post_listing_3_element_image_preference',
								 'options'		=> $image_preference_options,
								 'value' 		=> 'image_post_only',
							),
							array(
								"type"			=>	"text",
								"label"			=>	esc_html__('No. Of Posts Per Page', DZ_TH_DOMAIN ),
								"name"			=>	"post_listing_3_element_no_of_posts",
								"description"	=>	esc_html__('Enter no. of posts to show per page.', DZ_TH_DOMAIN ),
								'value'			=> 	'3'
							),
							array(
								"type"			=>	"select",
								"label"			=>	esc_html__("Order By", DZ_TH_DOMAIN),
								"name"			=>	"post_listing_3_element_orderby",
								'options'		=>	$orderby_options,
								"description"	=>	esc_html__("Enter the sorting order.", DZ_TH_DOMAIN),
								'value'			=> 	'date'
							),
							array(
								"type"			=>	"select",
								"label"			=>	esc_html__("Order", DZ_TH_DOMAIN),
								"name"			=>	"post_listing_3_element_order",
								'options'		=>	$order_options,			
								"description"	=>	esc_html__("Enter the sorting order.", DZ_TH_DOMAIN),
								'value'			=> 	'DESC'
							)
						),
						//Tabs Start
						esc_html__( 'Sidebar', DZ_TH_DOMAIN ) => array(
							array(
							   'type' => 'dropdown',
							   'label' => esc_html__( 'Choose Sidebar', DZ_TH_DOMAIN ),
							   'name' => 'post_listing_3_element_selected_sidebar',
							   'options' => $selected_sidebar_options,
							   'description' => esc_html__( 'Choose Sidebar.', DZ_TH_DOMAIN ),
							   'value'			=> 	'dz_blog_sidebar'
							),
							array(
								"type"			=>	"select",
								"label"			=>	esc_html__("Sidebar Selection", DZ_TH_DOMAIN),
								"name"			=>	"post_listing_3_element_sidebar_layout",
								'options'		=>	$sidebar_layout_options,			
								"description"	=>	esc_html__("Select Sidebar or show with out sidebar.", DZ_TH_DOMAIN),
								'value'			=> 	'right'
							),
						),
						//Tabs End
					),
			);

/* post_listing_4 */
$options['dz_post_listing_4_element']	=	array(
					'name' => esc_html__('Post Listing 4', DZ_TH_DOMAIN),
					'base' => 'dz_post_listing_4_element',
					'class' => '',
					'category' => esc_html__('Jobzilla', DZ_TH_DOMAIN),
					'icon' => 'dz-post-listing-4-kc' ,
					'description' => esc_html__('Shows Post Listing style 4.', DZ_TH_DOMAIN),
					'params' => array(
						esc_html__( 'General', DZ_TH_DOMAIN ) => array(	
							array(
								"type"			=>	"text",
								"label"			=>	esc_html__('Title', DZ_TH_DOMAIN ),
								"name"			=>	"post_listing_4_element_title",
								"description"	=>	esc_html__('Enter section title.', DZ_TH_DOMAIN ),
							),
							array(
								"type"			=>	"textarea",
								"label"			=>	esc_html__('Description', DZ_TH_DOMAIN ),
								"name"			=>	"post_listing_4_element_description",
								"description"	=>	esc_html__('Enter section description.', DZ_TH_DOMAIN ),
							),
							array(
								"type"			=>	"text",
								"label"			=>	esc_html__('Text Limit', DZ_TH_DOMAIN ),
								"name"			=>	"post_listing_4_element_text_limit",
								"description"	=>	esc_html__('Enter text limit of post title to Show. 0 for full title', DZ_TH_DOMAIN ),
								'value'			=> 	'7'
							),
							array(
								'type' => 'multiple', 
								'label' => __('Include These Categories', DZ_TH_DOMAIN ),
								'name' => 'post_listing_4_element_posts_in_categories',
								"options" =>  $posts_in_categories_options,
								'description' => __('Select multiple/ single categories', DZ_TH_DOMAIN ),
								'value'		=> 	'0'
							),	
							array(
							 'type' => 'toggle',
							 'label' => esc_html__( 'Include Only Featured Posts', DZ_TH_DOMAIN ),
							 'name' => 'post_listing_4_element_only_featured_posts',
							 'description' => esc_html__( 'Choose to show only featured posts.', DZ_TH_DOMAIN ),
							 'value' => 'no'
							),
						),
						esc_html__( 'Pagination', DZ_TH_DOMAIN ) => array(
							array(
								 'type' => 'select',
								 'label' => esc_html__( 'Pagination Style', DZ_TH_DOMAIN ),
								 'name' => 'post_listing_4_element_pagination_style',
								 'options' => $pagination_options,
								 'description' => esc_html__( 'You can choose pagination style from here.', DZ_TH_DOMAIN ),
								 'value' => 'yes'
							),
							array(
								 'type' 		=> 'select',
								 'label' 		=> esc_html__( 'Post Image Preference', DZ_TH_DOMAIN ),
								 'name' 		=> 'post_listing_4_element_image_preference',
								 'options'		=> $image_preference_options,
								 'value' 		=> 'image_post_only',
							),
							array(
								"type"			=>	"text",
								"label"			=>	esc_html__('No. Of Posts Per Page', DZ_TH_DOMAIN ),
								"name"			=>	"post_listing_4_element_no_of_posts",
								"description"	=>	esc_html__('Enter no. of posts to show per page.', DZ_TH_DOMAIN ),
								'value'			=> 	'3'
							),
							array(
								"type"			=>	"select",
								"label"			=>	esc_html__("Order By", DZ_TH_DOMAIN),
								"name"			=>	"post_listing_4_element_orderby",
								'options'		=>	$orderby_options,
								"description"	=>	esc_html__("Enter the sorting order.", DZ_TH_DOMAIN),
								'value'			=> 	'date'
							),
							array(
								"type"			=>	"select",
								"label"			=>	esc_html__("Order", DZ_TH_DOMAIN),
								"name"			=>	"post_listing_4_element_order",
								'options'		=>	$order_options,			
								"description"	=>	esc_html__("Enter the sorting order.", DZ_TH_DOMAIN),
								'value'			=> 	'DESC'
							)
						),
						//Tabs Start
						esc_html__( 'Sidebar', DZ_TH_DOMAIN ) => array(
							array(
							   'type' => 'dropdown',
							   'label' => esc_html__( 'Choose Sidebar', DZ_TH_DOMAIN ),
							   'name' => 'post_listing_4_element_selected_sidebar',
							   'options' => $selected_sidebar_options,
							   'description' => esc_html__( 'Choose Sidebar.', DZ_TH_DOMAIN ),
							   'value'			=> 	'dz_blog_sidebar'
							),
							array(
								"type"			=>	"select",
								"label"			=>	esc_html__("Sidebar Selection", DZ_TH_DOMAIN),
								"name"			=>	"post_listing_4_element_sidebar_layout",
								'options'		=>	$sidebar_layout_options,			
								"description"	=>	esc_html__("Select Sidebar or show with out sidebar.", DZ_TH_DOMAIN),
								'value'			=> 	'right'
							),
						),
						//Tabs End
					),
			);			
			
/* category_slider_1 */
$options['dz_category_slider_1_element']	=	array(
					'name' => esc_html__('Category Slider 1', DZ_TH_DOMAIN),
					'base' => 'dz_category_slider_1_element',
					'class' => '',
					'category' => esc_html__('Jobzilla', DZ_TH_DOMAIN),
					'icon' => 'dz-category-slider-1-kc' ,
					'description' => esc_html__('Shows Category Slider style 1.', DZ_TH_DOMAIN),
					'params' => array(
						esc_html__( 'General', DZ_TH_DOMAIN ) => array(
							array(
								"type"			=>	"text",
								"label"			=>	esc_html__('Section Heading', DZ_TH_DOMAIN ),
								"name"			=>	"category_slider_1_element_title",
							),
							array(
								'type' => 'textarea',
								'label' => esc_html__( 'Section Description', DZ_TH_DOMAIN ),
								'name' => 'category_slider_1_element_description',
								'description' => esc_html__( 'Enter section description.', DZ_TH_DOMAIN ),
							),
							array(
								'type' 			=> 'multiple', 
								'label' 		=> esc_html('Include These Categories', DZ_TH_DOMAIN ),
								'name' 			=> 'category_slider_1_element_posts_in_categories',
								"options" 		=> $posts_in_categories_options,
								'value'			=> 0,
							),	
						),
						esc_html__( 'Advance', DZ_TH_DOMAIN ) => array(
							array(
								"type"			=>	"select",
								"label"			=>	esc_html__("Order By", DZ_TH_DOMAIN),
								"name"			=>	"category_slider_1_orderby",
								'options'		=>	$cat_orderby_options,
								'value'			=> 	'date',
							),
							array(
								"type"			=>	"select",
								"label"			=>	esc_html__("Sort Order", DZ_TH_DOMAIN),
								"name"			=>	"category_slider_1_order",
								'options'		=>	$order_options,			
								'value'			=>	'DESC'
							),
						)
					),
			);	
			
/* image_carousel_1 */
$options['dz_image_carousel_1_element']	=	array(
					'name' => esc_html__('Image Carousel 1', DZ_TH_DOMAIN),
					'base' => 'dz_image_carousel_1_element',
					'class' => '',
					'category' => esc_html__('Jobzilla', DZ_TH_DOMAIN),
					'icon' => 'dz-image-carousel-1-kc' ,
					'description' => esc_html__('Shows Image Carousel style 1.', DZ_TH_DOMAIN),
					'params' => array(
						array(
							"type"			=>	"text",
							"label"			=>	esc_html__('Title', DZ_TH_DOMAIN ),
							"name"			=>	"image_carousel_1_element_title",
							"description"	=>	esc_html__('Enter section title.', DZ_TH_DOMAIN ),
						),
						array(
							"type"			=>	"textarea",
							"label"			=>	esc_html__('Description', DZ_TH_DOMAIN ),
							"name"			=>	"image_carousel_1_element_description",
							"description"	=>	esc_html__('Enter section description.', DZ_TH_DOMAIN ),
						),
						array(
							"type"			=>	'attach_images',
							"label"			=>	esc_html__('Carousel Images', DZ_TH_DOMAIN ),
							"name"			=>	"image_carousel_1_element_carousel_image",
							"description"	=>	esc_html__('Enter carousel images.', DZ_TH_DOMAIN ),
						),
					),
			);	

/* subscription_1 */
$options['dz_subscription_1_element']	=	array(
					'name' => esc_html__('Subscription 1', DZ_TH_DOMAIN),
					'base' => 'dz_subscription_1_element',
					'class' => '',
					'category' => esc_html__('Jobzilla', DZ_TH_DOMAIN),
					'icon' => 'dz-subscription-1-kc' ,
					'description' => esc_html__('Shows Subscription Element style 1.', DZ_TH_DOMAIN),
					'params' => array(
						array(
							"type"			=>	"text",
							"label"			=>	esc_html__('Title', DZ_TH_DOMAIN ),
							"name"			=>	"subscription_1_element_title",
							"description"	=>	esc_html__('Enter section title.', DZ_TH_DOMAIN ),
						),
						array(
							"type"			=>	"textarea",
							"label"			=>	esc_html__('Description', DZ_TH_DOMAIN ),
							"name"			=>	"subscription_1_element_description",
							"description"	=>	esc_html__('Enter section description.', DZ_TH_DOMAIN ),
						),
						array(
							"type"			=>	"text",
							"label"			=>	esc_html__('Subscription Form Title', DZ_TH_DOMAIN ),
							"name"			=>	"subscription_1_element_form_title",
							"description"	=>	esc_html__('Enter subscription title.', DZ_TH_DOMAIN ),
							'value'			=> esc_html__('Join Up with Me',DZ_TH_DOMAIN),
						),
					),
			);	

/* contact_us_1 */
$options['dz_contact_us_1_element']	=	array(
					'name' => esc_html__('Contact Us 1', DZ_TH_DOMAIN),
					'base' => 'dz_contact_us_1_element',
					'class' => '',
					'category' => esc_html__('Jobzilla', DZ_TH_DOMAIN),
					'icon' => 'dz-contact-us-1-kc' ,
					'description' => esc_html__('Shows Contact Us Element style 1.', DZ_TH_DOMAIN),
					'params' => array(
							//Tabs Start
						esc_html__( 'General', DZ_TH_DOMAIN ) => array(
							array(
								"type"			=>	"text",
								"label"			=>	esc_html__('Title', DZ_TH_DOMAIN ),
								"name"			=>	"contact_us_1_element_title",
								"description"	=>	esc_html__('Enter title.', DZ_TH_DOMAIN ),
								'value'			=> esc_html__('Contact Me', DZ_TH_DOMAIN )
							),
							array(
								"type"			=>	"textarea",
								"label"			=>	esc_html__('Description', DZ_TH_DOMAIN ),
								"name"			=>	"contact_us_1_element_description",
								"description"	=>	esc_html__('Enter description.', DZ_TH_DOMAIN ),
							),
							array(
								'type' => 'attach_image_url',
								'label' => esc_html__( 'Banner Image', DZ_TH_DOMAIN ),
								'name' => 'contact_us_1_element_image',
								'description' => esc_html__( 'choose banner image.', DZ_TH_DOMAIN ),
							),
							array(
								"type"			=>	"select",
								"label"			=>	esc_html__('Contact Form', DZ_TH_DOMAIN ),
								"name"			=>	"contact_us_1_element_contact_form",
								"description"	=>	esc_html__('Choose Contact Form to show.', DZ_TH_DOMAIN ),
								'options'		=>  $contact_form_options,
								'value'			=>  '5'
							),
						),
						//Tabs End
						
						//Tabs Start
						esc_html__( 'Contact Information', DZ_TH_DOMAIN ) => array(
							array(
								"type"			=>	"text",
								"label"			=>	esc_html__('Contact Heading', DZ_TH_DOMAIN ),
								"name"			=>	"contact_us_1_element_contact_title",
								'value'			=> esc_html__('Additional Info', DZ_TH_DOMAIN )
							),
							array(
								 'type' 		=> 'toggle',
								 'label' 		=> esc_html__( 'Show Social Icon', DZ_TH_DOMAIN ),
								 'name' 		=> 'contact_us_1_element_show_social_icon',
								 'description' 	=> esc_html__( 'Enable to show social icons.', DZ_TH_DOMAIN ),
								 'value' 		=> 'yes'
							),
							//Group Start
							array(
								'type' => 'group',
								'label' => esc_html__( 'Contact Information', DZ_TH_DOMAIN ),
								'name' => 'contact_us_1_element_information',
								'description' => esc_html__( 'Enter contact information.', DZ_TH_DOMAIN ),
								'params' => array(
									array(
										'type' => 'text',
										'label' => esc_html__( 'Content', DZ_TH_DOMAIN ),
										'name' => 'contact_us_1_element_information_description',
										'description' => esc_html__( 'Enter content', DZ_TH_DOMAIN ),
									),
									array(
										'type' => 'icon_picker',
										'label' => esc_html__( 'Icon', DZ_TH_DOMAIN ),
										'name' => 'contact_us_1_element_information_icon',
										'description' => esc_html__( 'Choose icon.', DZ_TH_DOMAIN ),
									),
								),
							),//Group End
						),
						//Tabs End
					),
			);	

/* about_us_1 */
$options['dz_about_us_1_element']	=	array(
					'name' => esc_html__('About Us 1', DZ_TH_DOMAIN),
					'base' => 'dz_about_us_1_element',
					'class' => '',
					'category' => esc_html__('Jobzilla', DZ_TH_DOMAIN),
					'icon' => 'dz-about-us-1-kc' ,
					'description' => esc_html__('Shows Post Listing style 6.', DZ_TH_DOMAIN),
					'is_container' => true,
					'params' => array(
						//Tabs Start
						esc_html__( 'General', DZ_TH_DOMAIN ) => array(
							array(
								"type"			=>	"text",
								"label"			=>	esc_html__('Title', DZ_TH_DOMAIN ),
								"name"			=>	"about_us_1_element_title",
								"description"	=>	esc_html__('Enter title.', DZ_TH_DOMAIN ),
								'value'			=> esc_html__('About Me', DZ_TH_DOMAIN )
							),
							array(
								"type"			=>	"textarea",
								"label"			=>	esc_html__('Description', DZ_TH_DOMAIN ),
								"name"			=>	"about_us_1_element_description",
								"description"	=>	esc_html__('Enter description.', DZ_TH_DOMAIN ),
							),
							array(
								'type' => 'attach_image_url',
								'label' => esc_html__( 'Banner Image', DZ_TH_DOMAIN ),
								'name' => 'about_us_1_element_image',
								'description' => esc_html__( 'choose banner image.', DZ_TH_DOMAIN ),
							),
						),
						//Tabs End
						
						//Tabs Start
						esc_html__( 'Content', DZ_TH_DOMAIN ) => array(
							array(
								"type"			=>	"textarea_html",
								"label"			=>	esc_html__('Content', DZ_TH_DOMAIN ),
								"name"			=>	"content",
								"description"	=>	esc_html__('Enter left side description.', DZ_TH_DOMAIN ),
							),
							array(
								 'type' 		=> 'toggle',
								 'label' 		=> esc_html__( 'Show Social Icon', DZ_TH_DOMAIN ),
								 'name' 		=> 'about_us_1_element_show_social_icon',
								 'description' 	=> esc_html__( 'Enable to show social icons.', DZ_TH_DOMAIN ),
								 'value' 		=> 'yes'
							),
						),
						//Tabs End
					),
			);	

				
			
/* post_tab_1 */
$options['dz_post_tab_1_element']	=	array(
					'name' => esc_html__('Post Tab 1', DZ_TH_DOMAIN),
					'base' => 'dz_post_tab_1_element',
					'class' => '',
					'category' => esc_html__('Jobzilla', DZ_TH_DOMAIN),
					'icon' => 'dz-post-tab-1-kc' ,
					'description' => esc_html__('Shows Post Tab style 1.', DZ_TH_DOMAIN),
					'params' => array(
						//Tabs Start
						esc_html__( 'General', DZ_TH_DOMAIN ) => array(
							array(
								"type"			=>	"text",
								"label"			=>	esc_html__('Title', DZ_TH_DOMAIN ),
								"name"			=>	"post_tab_1_element_title",
								"description"	=>	esc_html__('Enter title.', DZ_TH_DOMAIN ),
							),
							array(
								"type"			=>	"textarea",
								"label"			=>	esc_html__('Description', DZ_TH_DOMAIN ),
								"name"			=>	"post_tab_1_element_description",
								"description"	=>	esc_html__('Enter description.', DZ_TH_DOMAIN ),
							),
						),
						//Tabs End
						//Tabs Start
						esc_html__( 'Tabs Content', DZ_TH_DOMAIN ) => array(
							//Group Start
							array(
								'type' => 'group',
								'label' => esc_html__( 'Post Tabs', DZ_TH_DOMAIN ),
								'name' => 'post_tab_1_element_tabs',
								'description' => esc_html__( 'Enter the Slider.', DZ_TH_DOMAIN ),
								'params' => array(
									array(
										"type"			=>	"text",
										"label"			=>	esc_html__('Title', DZ_TH_DOMAIN ),
										"name"			=>	"post_tab_1_element_tab_title",
										"description"	=>	esc_html__('Enter title.', DZ_TH_DOMAIN ),
										'value'			=> esc_html__('Trending', DZ_TH_DOMAIN )
									),
									array(
										'type' 			=> 'multiple', 
										'label' 		=> esc_html('Include These Categories', DZ_TH_DOMAIN ),
										'name' 			=> 'post_tab_1_element_posts_in_categories',
										"options" 		=> $posts_in_categories_options,
										'value'			=> 0,
									),
									array(
										'type'			=>	'text',
										'label'			=>	esc_html__('No. Of Posts Per Page', DZ_TH_DOMAIN ),
										'name'			=>	'post_tab_1_element_no_of_posts',
										'description'	=>	esc_html__('Enter no. of posts to show per page.', DZ_TH_DOMAIN ),
										'value'			=> 	'3'
									),
									array(
										'type'			=>	'select',
										'label'			=>	esc_html__('Order By', DZ_TH_DOMAIN),
										'name'			=>	'post_tab_1_element_orderby',
										'options'		=>	$orderby_options,
										'description'	=>	esc_html__('Enter the sorting order.', DZ_TH_DOMAIN),
										'value'			=> 	'date'
									),
									array(
										'type'			=>	'select',
										'label'			=>	esc_html__('Order', DZ_TH_DOMAIN),
										'name'			=>	'post_tab_1_element_order',
										'options'		=>	$order_options,			
										'description'	=>	esc_html__('Enter the sorting order.', DZ_TH_DOMAIN),
										'value'			=> 	'DESC'
									),
									array(
										'type' 		=> 'toggle',
										'label' 		=> esc_html__( 'Include Only Featured Posts', DZ_TH_DOMAIN ),
										'name' 		=> 'post_tab_1_element_only_featured_posts',
										'description' 	=> esc_html__( 'Choose to show only featured posts.', DZ_TH_DOMAIN ),
										'value' 		=> 'no'
									),
									
								),
							),//Group End
						),
						//Tabs End
						
					),
			);
			
/* sidebar */
$options['dz_sidebar_element']	=	array(
					'name' => esc_html__('Sidebar', DZ_TH_DOMAIN),
					'base' => 'dz_sidebar_element',
					'class' => '',
					'category' => esc_html__('Jobzilla', DZ_TH_DOMAIN),
					'icon' => 'dz-sidebar-kc' ,
					'description' => esc_html__('Shows Sidebar.', DZ_TH_DOMAIN),
					'params' => array(
						array(
							'type' => 'dropdown',
							'label' => esc_html__( 'Choose Sidebar', DZ_TH_DOMAIN ),
							'name' => 'sidebar_element_selected_sidebar',
							'options' => $selected_sidebar_options,
							'description' => esc_html__( 'Choose Sidebar.', DZ_TH_DOMAIN ),
							'value'		=> 	'dz_blog_sidebar'
						),
						array(
							'type' 		=> 'toggle',
							'label' 		=> esc_html__( 'Is Sticky', DZ_TH_DOMAIN ),
							'name' 		=> 'sidebar_element_is_sticky',
							'description' 	=> esc_html__( 'Enable to sidebar sticky.', DZ_TH_DOMAIN ),
							'value' 		=> 'yes'
						),
					),
			);

/* Site Down */
$options['dz_sitedown_element']	=	array(
					'name' => esc_html__('Site Down', DZ_TH_DOMAIN),
					'base' => 'dz_sitedown_element',
					'class' => '',
					'category' => esc_html__('Jobzilla', DZ_TH_DOMAIN),
					'icon' => 'dz-pagedown-kc' ,
					'description' => esc_html__('Show Site Down.', DZ_TH_DOMAIN),
					'params' => array(
					),
			);

/* Coming Soon */
$options['dz_comingsoon_element']	=	array(
					'name' => esc_html__('Coming Soon', DZ_TH_DOMAIN),
					'base' => 'dz_comingsoon_element',
					'class' => '',
					'category' => esc_html__('Jobzilla', DZ_TH_DOMAIN),
					'icon' => 'dz-coming-soon-kc' ,
					'description' => esc_html__('Show Coming Soon.', DZ_TH_DOMAIN),
					'params' => array(
					),
			);			


return $options;