<?php
/**
 * @template: import-export-handle.php
 * @since: 1.0.0
 * @author: DexignZone
 * @create: 16-Nov-17
 */
if (!defined('ABSPATH')) {
    die();
}
if (!class_exists('DZ_Import_handle')) {
    class DZ_Import_handle
    {
        public function __construct()
        {
            add_action('init', array($this, 'dz_ie_template_redirect'), 30);
        }

        public function dz_ie_template_redirect()
        {
			
            if (!isset($_REQUEST['page']) || $_REQUEST['page'] !== 'dz-import') {
                return;
            }
            /**
             * Export handle
             *
             */
            if (!empty($_REQUEST['action']) && $_REQUEST['action'] === 'dz-export' && !empty($_REQUEST['dz-ie-id']) && !empty($_REQUEST['dz-ie-data-type'])) {
				
                $folder_name = sanitize_title($_REQUEST['dz-ie-id']);
                $folder_dir = dz_ie_process_demo_folder($folder_name);
                $this->dz_ie_get_screen_shot($folder_name);
                do_action('dz-ie-export-start', $folder_dir);
                $this->dz_ie_export_start($folder_dir);
                /**
                 * Hook dz-ie-extra-options
                 * Export and import extra options
                 * Return $options ( array( $option_key1 , $option_key1 , $option_key3....) )
                 */
                $options = array();
                $options = apply_filters('dz_ie_extra_options', $options);
                $demo_info = array(
                    'name' => $_REQUEST['dz-ie-id'],
                    'link' => !empty($_REQUEST['dz-ie-link']) ? $_REQUEST['dz-ie-link'] : '#'
                );

                /**
                 * Export demo information
                 */
                dz_ie_export_demo_info($folder_dir . 'demo-info.json', $demo_info);

                /**
                 * Export extra options
                 */
                dz_ie_extra_options_export($folder_dir . 'extra-options.json', $options);

                /**
                 * Export main
                 */
				 
                foreach ($_REQUEST['dz-ie-data-type'] as $type) {
                    switch ($type) {
                        case 'attachment':
                            dz_ie_media_export($folder_dir);
                            break;
                        case 'widgets':
                            dz_ie_widgets_save_export_file($folder_dir);
                            break;
                        case 'settings':
                            dz_ie_setting_export($folder_dir . 'settings.json');
                            break;
                        case 'options':
                            dz_ie_options_export($folder_dir . 'options.json');
                            break;
                        case 'content':
                            dz_ie_content_export($folder_dir);
                            break;
                        case 'revslider':
                            dz_ie_revslider_export($folder_dir);
                            break;
                    }
                }
                dz_term_meta_export($folder_dir . 'term-meta.json');

                /**
                 * Clear temp
                 */
                dz_ie_clear_tmp();

                /**
                 * Git sync
                 */
                dz_git_shell();
            }

            /**
             * Import handle
             *
             */
            if (!empty($_REQUEST['action']) && $_REQUEST['action'] === 'dz-import' && !empty($_REQUEST['dz-ie-id'])) {
                $GLOBALS['import_result'] = array();

                $folder_name = sanitize_title($_REQUEST['dz-ie-id']);
                $folder_dir = dz_ie_process_demo_folder($folder_name);
                $options = array();
                if (file_exists($folder_dir . 'options.json')) {
                    $options = json_decode(file_get_contents($folder_dir . 'options.json'), true);
                }
                $options['folder'] = $folder_dir;
                do_action('dz-ie-export-start', $folder_dir);
                $this->dz_ie_import_start($folder_dir);

                //attachment
                dz_ie_media_import($options, $folder_dir);
					
                //content
                dz_ie_content_import($options);
				
                //settings
                dz_ie_setting_import($folder_dir . 'settings.json');
				
				/* Generate Dynamic Sidebar */
				$this->dz_ie_generateDynamicSidebar();
				
				//options
                dz_ie_options_import($options);

                //widgets
                dz_ie_widgets_process_import_file($folder_dir);

                //extra options
                dz_ie_extra_options_import($folder_dir . 'extra-options.json');

                //revslider
                dz_ie_revslider_import($folder_dir);

                $this->dz_ie_crop_images();

                dz_term_meta_import($folder_dir . 'term-meta.json');
                /**
                 * Save demo id installed
                 */
                dz_ie_import_finish($_REQUEST['dz-ie-id']);


                /**
                 * Clear tmp:
                 * $upload_dir['basedir'] . '/dz-attachment-tmp
                 * $upload_dir['basedir'] . '/dz-ie-demo
                 */
                dz_ie_clear_tmp();
            }

            /**
             * Download zip file of all demo data
             */
            if (!empty($_REQUEST['dz-ie-download']) && $_REQUEST['dz-ie-download'] === 'dz' && !empty($_REQUEST['action']) && $_REQUEST['action'] === 'dz-export') {
                $zip_file = dz_ie_download_demo_zip();
                header("Content-type: application/zip");
                header("Content-Disposition: attachment; filename=demo-data.zip");
                header("Pragma: no-cache");
                header("Expires: 0");
                readfile($zip_file);

                @unlink($zip_file); //delete file after sending it to user

                exit();
            }

        }


        /**
         * Copy screen_shot of demo
         * @param $folder_name
         */
        function dz_ie_get_screen_shot($folder_name)
        {

            if (is_file(dz_ie()->theme_dir . $folder_name . '/screenshot.png'))
                return;

            if (!is_file(get_template_directory() . '/screenshot.png'))
                return;

            copy(get_template_directory() . '/screenshot.png', dz_ie()->theme_dir . $folder_name . '/screenshot.png');
        }


        function dz_ie_export_start($part)
        {
            $css_file = get_template_directory() . '/assets/css/static.css';

            if (file_exists($css_file)) {
                copy($css_file, $part . 'static.css');
            }
        }

        function dz_ie_import_start($part)
        {
            $css = get_template_directory() . '/assets/css/static.css';

            if (file_exists($part . 'static.css')) {
                copy($part . 'static.css', $css);
            }
        }

        function dz_ie_crop_images()
        {
            global $import_result;

            /**
             * Crop image
             */
            $query = array(
                'post_type'      => 'attachment',
                'posts_per_page' => -1,
                'post_status'    => 'inherit',
            );

            $media = new WP_Query($query);
            if ($media->have_posts()) {
                foreach ($media->posts as $image) {
                    if (strpos($image->post_mime_type, 'image/') !== false) {
                        $image_path = get_attached_file($image->ID);
                        $metadata = wp_generate_attachment_metadata($image->ID, $image_path);
                        wp_update_attachment_metadata($image->ID, $metadata);
                    }
                }
                $import_result[] = esc_html__('Crop images successfully!', DZ_TEXT_DOMAIN);
            }
        }
		
		/*
			-- Generate Dynamic Sidebar
			-- Created On 15 April 2021 
		*/
		function dz_ie_generateDynamicSidebar()
        {
			if (class_exists('ReduxFramework')) {

				$sidebar_input_arr = Jobzilla_get_opt( 'new_sidebar_input' );
        
				if(!empty( $sidebar_input_arr[0])) {
					foreach($sidebar_input_arr as $sidebar_input)
					{
						$sidebarId = str_replace(' ', '_', $sidebar_input);
					
						register_sidebar(array(
							'name'          => ucfirst($sidebar_input),
							'id'            => sanitize_title('dz_' . $sidebarId),
							'description'   => esc_html__( 'Widgets in this area will be shown on the right-hand side.', 'Jobzilla' ),
							'before_widget'	=>'<div id="%1$s" class="widget sidebar-widget %2$s substitute-class">',
							'after_widget'	=>'</div>',
							'before_title' 	=> '<h5 class="title">',
							'after_title' 	=> '</h5>'
						));	
					}
				}
			}
		}
    }
}


		