<?php
/**
 * @since: 1.0.0
 * @author: DexignZone
 * @create: 16-Nov-17
 */
?>
<div class="dz-export-demos">
    <h3><?php echo esc_html__('Export', DZ_TEXT_DOMAIN) ?></h3>
    <form method="post" class="dz-export-contents">
        <div class="dz-export-name">
            <input required='' type="text" id="dz-ie-id" name="dz-ie-id" placeholder='<?php echo esc_html__('Name', DZ_TEXT_DOMAIN) ?>'>
        </div>
        <div class="dz-export-link">
            <input required='' type="text" id="dz-ie-link" name="dz-ie-link" placeholder='<?php echo esc_html__('Demo Link', DZ_TEXT_DOMAIN) ?>'>
        </div>
        <div class="dz-export-options">
            <h4><?php echo esc_html__('Select data:', DZ_TEXT_DOMAIN) ?></h4>
            <div class="dz-export-list-opt">
                <div class="dz-checkbox-wrap">
                    <div class="dz-checkbox">
                        <input id="dz-ie-data-media" name="dz-ie-data-type[]" type="checkbox" value="attachment" checked="checked">
                        <span></span>
                        <label for="dz-ie-data-media"><?php esc_html_e('Media', DZ_TEXT_DOMAIN); ?></label>
                    </div>
                </div>
                <div class="dz-checkbox-wrap">
                    <div class="dz-checkbox">
                        <input id="dz-ie-data-widget" name="dz-ie-data-type[]" type="checkbox" value="widgets"
                               checked="checked">
                        <span></span>
                        <label for="dz-ie-data-widget"><?php esc_html_e('Widgets', DZ_TEXT_DOMAIN); ?></label>
                    </div>
                </div>
                <div class="dz-checkbox-wrap">
                    <div class="dz-checkbox">
                        <input id="dz-ie-data-setting" name="dz-ie-data-type[]" type="checkbox" value="options"
                               checked="checked">
                        <span></span>
                        <label for="dz-ie-data-setting"><?php esc_html_e('WP Settings', DZ_TEXT_DOMAIN); ?></label>
                    </div>
                </div>
                <?php if (class_exists('ReduxFramework')): ?>
                    <div class="dz-checkbox-wrap">
                        <div class="dz-checkbox">
                            <input id="dz-ie-data-option" name="dz-ie-data-type[]" type="checkbox" value="settings"
                                   checked="checked">
                            <span></span>
                            <label for="dz-ie-data-option"><?php esc_html_e('Theme Options', DZ_TEXT_DOMAIN); ?></label>
                        </div>
                    </div>
                <?php endif; ?>

                <?php if (function_exists('cptui_get_post_type_data')): ?>
                    <div class="dz-checkbox-wrap">
                        <div class="dz-checkbox">
                            <input id="dz-ie-data-posttype" name="dz-ie-data-type[]" type="checkbox" value="ctp_ui"
                                   checked="checked">
                            <span></span>
                            <label for="dz-ie-data-posttype"><?php esc_html_e('Post Type', DZ_TEXT_DOMAIN); ?></label>
                        </div>
                    </div>
                <?php endif; ?>
                <div class="dz-checkbox-wrap">
                    <div class="dz-checkbox">
                        <input id="dz-ie-data-content" name="dz-ie-data-type[]" type="checkbox" value="content"
                               checked="checked">
                        <span></span>
                        <label for="dz-ie-data-content"><?php esc_html_e('Content', DZ_TEXT_DOMAIN); ?></label>
                    </div>
                </div>
                <?php if (class_exists('RevSlider')): ?>
                    <div class="dz-checkbox-wrap">
                        <div class="dz-checkbox">
                            <input id="dz-ie-data-rev" name="dz-ie-data-type[]" type="checkbox" value="revslider"
                                   checked="checked">
                            <span></span>
                            <label for="dz-ie-data-rev"><?php esc_html_e('Slider Revolution', DZ_TEXT_DOMAIN); ?></label>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        <div class="dz-export-btn">
            <input type="hidden" name="action" value="dz-export">
            <button type="submit"
                    class="button button-primary create-demo"><?php esc_html_e('Create Demo', DZ_TEXT_DOMAIN); ?></button>
            <button type="submit" class="button button-primary download-demo" name="dz-ie-download"
                    value="dz"><?php esc_html_e('Download All Demos', DZ_TEXT_DOMAIN); ?></button>
        </div>
    </form>
</div>
