<?php
/**
 * @Template: Import demo page
 * @version: 1.0.0
 * @author: DexignZone
 * @descriptions: Display for import demo page in Dashboard framework
 */

$demo_list = dz_ie()->get_all_demo_folder();
$current_demo_installed = get_option('dz_ie_demo_installed', '');
$path = dz_ie()->theme_dir;
$url = dz_ie()->theme_url;

$_search = array('M','G','K','m','g','k');
$memory_limit = (int)str_replace($_search, null, ini_get("memory_limit"));
$max_time = (int)ini_get("max_execution_time");
$post_max_size = (int)str_replace($_search, null, ini_get('post_max_size'));
$php_ver = PHP_VERSION;
$_notice = ($memory_limit < 128 || $max_time < 60 || $post_max_size < 32) ? 'dz-ie-warning' : 'dz-ie-good';

?>
<div class="wrap">
    <div class="dz-ie-dashboard">
        <div class="dz-field-info <?php echo esc_attr($_notice); ?>">
            <table class="dz-server-info">
                <tr>
                    <th><?php esc_html_e('PHP Version:', DZ_TEXT_DOMAIN); ?></th>
                    <td><i class="dashicons dashicons-yes" style="color: #31f531"></i></td>
                    <td style="color: #0d880b"><?php echo esc_html($php_ver); ?></td>
                </tr>
                <tr>
                    <th><?php esc_html_e('Memory Limit:', DZ_TEXT_DOMAIN) ?></th>
                    <?php if($memory_limit >= 128): ?>
                        <td><i class="dashicons dashicons-yes" style="color: #31f531"></i></td>
                        <td style="color: #0d880b"><?php echo sprintf(esc_html__('Currently: %s (Mb)', ''), $memory_limit); ?></td>
                    <?php else: ?>
                        <td><i class="dashicons dashicons-no" style="color: red"></i></td>
                        <td style="color: red"><?php echo sprintf(esc_html__('Currently: %s (the minimum required 128M)', ''), $memory_limit); ?></td>
                    <?php endif; ?>
                </tr>
                <tr>
                    <th><?php esc_html_e('Max. Execution Time:', DZ_TEXT_DOMAIN) ?></th>
                    <?php if($max_time >= 60): ?>
                        <td><i class="dashicons dashicons-yes" style="color: #31f531"></i></td>
                        <td style="color: #0d880b"><?php echo sprintf(esc_html__('Currently: %s (s)', ''), $max_time); ?></td>
                    <?php else: ?>
                        <td><i class="dashicons dashicons-no" style="color: red"></i></td>
                        <td style="color: red"><?php echo sprintf(esc_html__('Currently: %ss (the minimum required 60s)', ''), $max_time); ?></td>
                    <?php endif; ?>
                </tr>
                <tr>
                    <th><?php esc_html_e('Max. Post Size:', DZ_TEXT_DOMAIN) ?></th>
                    <?php if($post_max_size >= 32): ?>
                        <td><i class="dashicons dashicons-yes" style="color: #31f531"></i></td>
                        <td style="color: #0d880b"><?php echo sprintf(esc_html__('Currently: %s (Mb)', ''), $post_max_size); ?></td>
                    <?php else: ?>
                        <td><i class="dashicons dashicons-no" style="color: red"></i></td>
                        <td style="color: red"><?php echo sprintf(esc_html__('Currently: %s (the minimum required 32M)', ''), $post_max_size); ?></td>
                    <?php endif; ?>
                </tr>
				<tr>
                    <th><?php esc_html_e('Please wait 10 to 15 minutes in demo import process.', DZ_TEXT_DOMAIN) ?></th>
				</tr>
            </table>
            </p>
        </div>
        
        <div class="dz-import-demos">
            <div class="dz-import-contains">
                <?php
                if (!empty($demo_list)):
                    foreach ($demo_list as $demo):
                        $file_demo_info = $path . $demo . '/demo-info.json';
                        $demo_installed = $current_demo_installed === $demo ? true : false;
                        if (file_exists($file_demo_info)):
                            $info_demo = json_decode(file_get_contents($file_demo_info), true);
                            ?>
                            <form method="post" class="dz-ie-demo-item" data-demo="demo-<?php echo $demo ?>"
                                  id="demo-<?php echo $demo ?>">
                                <div class="dz-ie-item-inner">
                                    <div class="dz-ie-image">
                                        <img src="<?php echo $url . $demo . '/screenshot.png' ?>" alt="">
                                        <a class="dz-ie-preview" href="<?php echo esc_attr($info_demo['link']) ?>"
                                           target="_blank">
                                            <span><?php esc_html_e('View Demo', DZ_TEXT_DOMAIN) ?></span>
                                        </a>
                                    </div>
                                    <div class="dz-ie-meta">
                                        <h4 class="dz-ie-demo-title"><?php echo esc_attr($info_demo['name']) ?></h4>
                                        <input type="hidden" name="dz-ie-id" value="<?php echo esc_attr($demo) ?>">
                                        <input type="hidden" name="action" value="dz-import">
                                        <button class="dz-import-btn dz-import-submit button button-primary"
                                                name="dz-import-submit"
                                                value="<?php echo base64_encode($demo) ?>"><?php echo $demo_installed === true ? esc_html__('Update Demo', DZ_TEXT_DOMAIN) : esc_html__('Import Demo', DZ_TEXT_DOMAIN) ?></button>
                                        <?php
                                        if ($demo_installed === true) {
                                            wp_nonce_field('dz-reset', '_wp_nonce');
                                            ?>
                                            <button class="dz-import-btn dz-delete-demo button button-primary"
                                                    name="dz-ie-delete-demo"
                                                    value="<?php echo base64_encode($demo) ?>"><?php esc_html_e('Reset Site', DZ_TEXT_DOMAIN) ?></button>
                                            <?php
                                        }
                                        ?>
                                    </div>
                                    <div class="dz-loading" style="display: none">
                                        <span class="dz-pinner"><span class="fa fa-spinner fa-spin"></span></span>
                                    </div>
                                </div>
                            </form>
                        <?php
                        endif;
                    endforeach;
                else:
                    ?>
                    <div class="dz-ie-demo-empty">
                        <span class="dashicons dashicons-warning"></span>
                        <h4 class="dz-ie-notice-empty"><?php echo esc_html__('Demos data is empty') ?></h4>
                    </div>
                <?php
                endif;
                ?>
            </div>
        </div>
        <?php
        if (!empty($export_mode)) {
            include_once dz_ie()->plugin_dir . 'templates/export-page.php';
        }
        ?>
    </div>
</div>
