<?php
/**
 * Shows the `checkbox` form field on job listing forms.
 *
 * This template can be overridden by copying it to yourtheme/job_manager/form-fields/checkbox-field.php.
 *
 * @see         https://wpjobmanager.com/document/template-overrides/
 * @author      Automattic
 * @package     wp-job-manager
 * @category    Template
 * @version     1.31.1
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>
<input type="checkbox" id="exampleCheck1" class="form-check-input" name="<?php echo esc_attr( isset( $field['name'] ) ? $field['name'] : $key ); ?>" id="<?php echo esc_attr( $key ); ?>" <?php checked( ! empty( $field['value'] ), true ); ?> value="1" <?php if ( ! empty( $field['required'] ) ) echo 'required'; ?> />
<?php if ( ! empty( $field['description'] ) ) : ?> <label class="form-check-label ms-1" for="exampleCheck1"><?php echo wp_kses_post( $field['description'] ); ?></label>
<?php endif; ?>
