<?php
/**
 * Cart totals
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     2.3.6
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>
<div class="cart_totals col-md-4 pull-right <?php if ( WC()->customer->has_calculated_shipping() ) echo 'calculated_shipping'; ?>">
	<?php do_action( 'woocommerce_before_cart_totals' ); ?>
	<h2>
		<?php esc_html_e( 'Cart Totals', 'jobzilla' ); ?>
	</h2>

	<table cellspacing="0">
		<tr class="cart-subtotal">
			<th>
				<?php esc_html_e( 'Subtotal', 'jobzilla' ); ?>
			</th>
			<td>
				<?php wc_cart_totals_subtotal_html(); ?>
			</td>
		</tr>

		<?php foreach ( WC()->cart->get_coupons() as $code => $coupon ) : ?>
			<tr class="cart-discount coupon-<?php echo esc_attr( sanitize_title( $code ) ); ?>">
				<th>
					<?php wc_cart_totals_coupon_label( $coupon ); ?>
				</th>
				<td>
					<?php wc_cart_totals_coupon_html( $coupon ); ?>
				</td>
			</tr>
		<?php endforeach; ?>

		<?php foreach ( WC()->cart->get_fees() as $fee ) : ?>
			<tr class="fee">
				<th>
					<?php echo esc_html( $fee->name ); ?>
				</th>
				<td>
					<?php wc_cart_totals_fee_html( $fee ); ?>
				</td>
			</tr>
		<?php endforeach; ?>

		<?php if ( wc_tax_enabled() && WC()->cart->get_tax_price_display_mode() == 'excl' ) : ?>
			<?php if ( get_option( 'woocommerce_tax_total_display' ) == 'itemized' ) : ?>
				<?php foreach ( WC()->cart->get_tax_totals() as $code => $tax ) : ?>
					<tr class="tax-rate tax-rate-<?php echo sanitize_title( $code ); ?>">
						<th>
							<?php echo esc_html( $tax->label ); ?>
						</th>
						<td>
							<?php echo wp_kses_post( $tax->formatted_amount ); ?>
						</td>
					</tr>
				<?php endforeach; ?>
			<?php else : ?>
				<tr class="tax-total">
					<th>
						<?php echo esc_html( WC()->countries->tax_or_vat() ); ?>
					</th>
					<td>
						<?php wc_cart_totals_taxes_total_html(); ?>
					</td>
				</tr>
			<?php endif; ?>
		<?php endif; ?>

		<?php do_action( 'woocommerce_cart_totals_before_order_total' ); ?>

		<tr class="order-total">
			<th>
				<?php esc_html_e( 'Total', 'jobzilla' ); ?>
			</th>
			<td>
				<?php wc_cart_totals_order_total_html(); ?>
			</td>
		</tr>
		<?php do_action( 'woocommerce_cart_totals_after_order_total' ); ?>
	</table>

	<?php if ( WC()->cart->get_cart_tax() ) : ?>
		<p class="wc-cart-shipping-notice">
			<small>
				<?php
					
					$estimated_text = WC()->customer->is_customer_outside_base() && ! WC()->customer->has_calculated_shipping()
						? sprintf( ' ' . wp_kses_post(__( ' (taxes estimated for %s)', 'jobzilla' )), WC()->countries->estimated_for_prefix() .  WC()->countries->countries[ WC()->countries->get_base_country() ])
						: '';					
					
					printf( wp_kses_post(__( 'Note: taxes are estimated %s and will be updated during checkout based on your billing and shipping information.', 'jobzilla' )),$estimated_text);
				?>
			</small>
		</p>
	<?php endif; ?>

	<div class="wc-proceed-to-checkout">
		<?php do_action( 'woocommerce_proceed_to_checkout' ); ?>
	</div>
	<?php do_action( 'woocommerce_after_cart_totals' ); ?>
</div>
